#include <iostream>
#include <string>
#include <stack>

using namespace std;

#define NORTH false
#define WEST true

long long pows[21];

long long gcd(long long a, long long b)
{
	if(a < b)
		return gcd(b, a);
	if(b == 0)
		return a;
	return gcd(b, a % b);
}

int main()
{
	pows[0] = 1;
	for(int i = 1; i < 21; i++)
	{
		pows[i] = pows[i-1]*2;
	}
	string a;
	stack<bool> dirs;
	while (cin >> a)
	{
		if(a.back() == '#')
			break;
		for(size_t i = 0; i < a.size();)
		{
			if(a[i] == 'n') //north
			{
				dirs.push(NORTH);
				i += 5;
			}
			else //west
			{
				dirs.push(WEST);
				i += 4;
			}
		}
		long long ans_up = 0, ans_down = 1;
		long long sum = 0;
		while(!dirs.empty())
		{
			if(dirs.top() == NORTH)
			{
				if(sum == 0)
				{
					ans_up = 0;
				}
				else
				{
					ans_up = ans_up*pows[sum] - 90*ans_down;
					ans_down = pows[sum]*ans_down;
				}
			}
			else
			{
				if(sum == 0)
				{
					ans_up = 90;
				}
				else
				{
					ans_up = ans_up*pows[sum] + 90*ans_down;
					ans_down = pows[sum]*ans_down;
				}
			}
			dirs.pop();
			sum++;
			long long ans_gcd = gcd(ans_up, ans_down);
			ans_up /= ans_gcd;
			ans_down /= ans_gcd;
		}
		if (ans_down == 1)
			cout << ans_up << endl;
		else
			cout << ans_up << "/" << ans_down << endl;
	}
	return 0;
}